/*=========================================================================

  Program:   Visualization Toolkit
  Module:    HierarchicalBoxPipeline.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkAMRBox.h"

int main( int arc, char **argv )
{
  double origin[] = {0,0,0};
  int    dim      = 2;
  int    ndim[]   = {5,5,1};
  double h[]      = {0.5,0.5,0.0};
  int    blockId  = 1;
  int    level    = 1;
  int    rank     = 0;

  vtkAMRBox myTestBox( origin, dim, ndim, h, blockId, level, rank );
  myTestBox.WriteToVtkFile( "initial0.vtk" );
  myTestBox.Print( std::cout );
  std::cout << "\n======================================================\n";
  std::cout.flush( );

  myTestBox.ExtrudeGhostCells( 3 );
  myTestBox.WriteToVtkFile( "initial1.vtk" );
  myTestBox.Print( std::cout );
  std::cout << "\n======================================================\n";
  std::cout.flush( );

//  myTestBox.ExtrudeGhostCells( 1 );
//  myTestBox.WriteToVtkFile( "initial2.vtk" );
//  myTestBox.Print( std::cout );
//  std::cout << "\n======================================================\n";
//  std::cout.flush( );

  return 0;
}
