// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include <vtkCallbackCommand.h>
#include <vtkChartParallelCoordinates.h>
#include <vtkContextActor.h>
#include <vtkContextKeyEvent.h>
#include <vtkContextMouseEvent.h>
#include <vtkContextView.h>
#include <vtkDoubleArray.h>
#include <vtkIdTypeArray.h>
#include <vtkInteractorEventRecorder.h>
#include <vtkNew.h>
#include <vtkPlotParallelCoordinates.h>
#include <vtkProperty.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkRenderer.h>
#include <vtkTable.h>

static const int expectedValues[] = { 23, 24, 25, 26, 49, 50, 51, 52, 53, 54, 55, 56, 57, 110, 111,
  112, 113, 114, 115, 116, 117, 118, 126, 140, 141, 142, 143, 190, 191, 192, 193 };

static const char* eventLog = "# StreamVersion 1.2\n"
                              "ExposeEvent 0 399 0 0 0 0 0\n"
                              "RenderEvent 0 399 0 0 0 0 0\n"
                              "TimerEvent 0 399 0 0 0 0 0\n"
                              "RenderEvent 0 399 0 0 0 0 0\n"
                              "EnterEvent 598 101 0 0 0 0 0\n"
                              "MouseMoveEvent 598 101 0 0 0 0 0\n"
                              "MouseMoveEvent 591 110 0 0 0 0 0\n"
                              "MouseMoveEvent 585 120 0 0 0 0 0\n"
                              "MouseMoveEvent 584 125 0 0 0 0 0\n"
                              "MouseMoveEvent 585 125 0 0 0 0 0\n"
                              "MouseMoveEvent 587 125 0 0 0 0 0\n"
                              "MouseMoveEvent 593 125 0 0 0 0 0\n"
                              "LeaveEvent 603 125 0 0 0 0 0\n"
                              "EnterEvent 598 120 0 0 0 0 0\n"
                              "MouseMoveEvent 598 120 0 0 0 0 0\n"
                              "MouseMoveEvent 576 116 0 0 0 0 0\n"
                              "MouseMoveEvent 541 110 0 0 0 0 0\n"
                              "MouseMoveEvent 507 105 0 0 0 0 0\n"
                              "MouseMoveEvent 465 102 0 0 0 0 0\n"
                              "MouseMoveEvent 429 102 0 0 0 0 0\n"
                              "MouseMoveEvent 393 102 0 0 0 0 0\n"
                              "MouseMoveEvent 358 106 0 0 0 0 0\n"
                              "MouseMoveEvent 338 106 0 0 0 0 0\n"
                              "MouseMoveEvent 326 103 0 0 0 0 0\n"
                              "MouseMoveEvent 325 99 0 0 0 0 0\n"
                              "MouseMoveEvent 331 95 0 0 0 0 0\n"
                              "MouseMoveEvent 339 90 0 0 0 0 0\n"
                              "MouseMoveEvent 340 89 0 0 0 0 0\n"
                              "MouseMoveEvent 342 92 0 0 0 0 0\n"
                              "MouseMoveEvent 345 98 0 0 0 0 0\n"
                              "MouseMoveEvent 352 109 0 0 0 0 0\n"
                              "MouseMoveEvent 355 119 0 0 0 0 0\n"
                              "MouseMoveEvent 357 130 0 0 0 0 0\n"
                              "MouseMoveEvent 360 145 0 0 0 0 0\n"
                              "MouseMoveEvent 362 162 0 0 0 0 0\n"
                              "MouseMoveEvent 363 184 0 0 0 0 0\n"
                              "MouseMoveEvent 364 196 0 0 0 0 0\n"
                              "MouseMoveEvent 365 211 0 0 0 0 0\n"
                              "MouseMoveEvent 367 223 0 0 0 0 0\n"
                              "MouseMoveEvent 366 231 0 0 0 0 0\n"
                              "MouseMoveEvent 365 240 0 0 0 0 0\n"
                              "MouseMoveEvent 363 245 0 0 0 0 0\n"
                              "MouseMoveEvent 362 251 0 0 0 0 0\n"
                              "MouseMoveEvent 362 254 0 0 0 0 0\n"
                              "MouseMoveEvent 362 256 0 0 0 0 0\n"
                              "MouseMoveEvent 362 258 0 0 0 0 0\n"
                              "MouseMoveEvent 359 259 0 0 0 0 0\n"
                              "MouseMoveEvent 347 265 0 0 0 0 0\n"
                              "MouseMoveEvent 325 268 0 0 0 0 0\n"
                              "MouseMoveEvent 301 270 0 0 0 0 0\n"
                              "MouseMoveEvent 275 270 0 0 0 0 0\n"
                              "MouseMoveEvent 257 270 0 0 0 0 0\n"
                              "MouseMoveEvent 243 269 0 0 0 0 0\n"
                              "MouseMoveEvent 230 266 0 0 0 0 0\n"
                              "MouseMoveEvent 222 265 0 0 0 0 0\n"
                              "MouseMoveEvent 213 263 0 0 0 0 0\n"
                              "MouseMoveEvent 208 262 0 0 0 0 0\n"
                              "MouseMoveEvent 203 260 0 0 0 0 0\n"
                              "MouseMoveEvent 197 258 0 0 0 0 0\n"
                              "MouseMoveEvent 196 258 0 0 0 0 0\n"
                              "MouseMoveEvent 194 257 0 0 0 0 0\n"
                              "MouseMoveEvent 198 258 0 0 0 0 0\n"
                              "MouseMoveEvent 207 260 0 0 0 0 0\n"
                              "MouseMoveEvent 213 262 0 0 0 0 0\n"
                              "MouseMoveEvent 220 264 0 0 0 0 0\n"
                              "MouseMoveEvent 223 264 0 0 0 0 0\n"
                              "MouseMoveEvent 224 265 0 0 0 0 0\n"
                              "MouseMoveEvent 225 266 0 0 0 0 0\n"
                              "MouseMoveEvent 224 267 0 0 0 0 0\n"
                              "MouseMoveEvent 223 268 0 0 0 0 0\n"
                              "MouseMoveEvent 220 269 0 0 0 0 0\n"
                              "MouseMoveEvent 219 270 0 0 0 0 0\n"
                              "MouseMoveEvent 218 272 0 0 0 0 0\n"
                              "MouseMoveEvent 218 274 0 0 0 0 0\n"
                              "MouseMoveEvent 217 275 0 0 0 0 0\n"
                              "MouseMoveEvent 216 276 0 0 0 0 0\n"
                              "MouseMoveEvent 215 277 0 0 0 0 0\n"
                              "MouseMoveEvent 215 278 0 0 0 0 0\n"
                              "MouseMoveEvent 215 279 0 0 0 0 0\n"
                              "MouseMoveEvent 215 280 0 0 0 0 0\n"
                              "MouseMoveEvent 213 280 0 0 0 0 0\n"
                              "MouseMoveEvent 212 281 0 0 0 0 0\n"
                              "MouseMoveEvent 212 282 0 0 0 0 0\n"
                              "MouseMoveEvent 212 283 0 0 0 0 0\n"
                              "MouseMoveEvent 212 284 0 0 0 0 0\n"
                              "MouseMoveEvent 212 285 0 0 0 0 0\n"
                              "MouseMoveEvent 212 286 0 0 0 0 0\n"
                              "MouseMoveEvent 212 287 0 0 0 0 0\n"
                              "MouseMoveEvent 212 288 0 0 0 0 0\n"
                              "MouseMoveEvent 212 289 0 0 0 0 0\n"
                              "MouseMoveEvent 212 290 0 0 0 0 0\n"
                              "MouseMoveEvent 212 291 0 0 0 0 0\n"
                              "MouseMoveEvent 213 291 0 0 0 0 0\n"
                              "MouseMoveEvent 213 292 0 0 0 0 0\n"
                              "MouseMoveEvent 214 293 0 0 0 0 0\n"
                              "MouseMoveEvent 214 296 0 0 0 0 0\n"
                              "MouseMoveEvent 215 297 0 0 0 0 0\n"
                              "MouseMoveEvent 216 298 0 0 0 0 0\n"
                              "MouseMoveEvent 216 299 0 0 0 0 0\n"
                              "MouseMoveEvent 217 300 0 0 0 0 0\n"
                              "MouseMoveEvent 217 301 0 0 0 0 0\n"
                              "MouseMoveEvent 217 302 0 0 0 0 0\n"
                              "MouseMoveEvent 218 303 0 0 0 0 0\n"
                              "MouseMoveEvent 219 304 0 0 0 0 0\n"
                              "MouseMoveEvent 220 305 0 0 0 0 0\n"
                              "MouseMoveEvent 221 306 0 0 0 0 0\n"
                              "MouseMoveEvent 221 307 0 0 0 0 0\n"
                              "MouseMoveEvent 222 308 0 0 0 0 0\n"
                              "MouseMoveEvent 222 309 0 0 0 0 0\n"
                              "MouseMoveEvent 222 308 0 0 0 0 0\n"
                              "MouseMoveEvent 221 307 0 0 0 0 0\n"
                              "MouseMoveEvent 219 304 0 0 0 0 0\n"
                              "MouseMoveEvent 219 303 0 0 0 0 0\n"
                              "MouseMoveEvent 219 302 0 0 0 0 0\n"
                              "LeftButtonPressEvent 219 302 0 0 0 0 0\n"
                              "TimerEvent 219 302 0 0 0 0 0\n"
                              "RenderEvent 219 302 0 0 0 0 0\n"
                              "MouseMoveEvent 219 301 0 0 0 0 0\n"
                              "MouseMoveEvent 218 300 0 0 0 0 0\n"
                              "MouseMoveEvent 217 298 0 0 0 0 0\n"
                              "MouseMoveEvent 217 297 0 0 0 0 0\n"
                              "MouseMoveEvent 217 296 0 0 0 0 0\n"
                              "MouseMoveEvent 216 295 0 0 0 0 0\n"
                              "TimerEvent 216 295 0 0 0 0 0\n"
                              "RenderEvent 216 295 0 0 0 0 0\n"
                              "MouseMoveEvent 217 292 0 0 0 0 0\n"
                              "MouseMoveEvent 216 291 0 0 0 0 0\n"
                              "MouseMoveEvent 216 289 0 0 0 0 0\n"
                              "MouseMoveEvent 217 288 0 0 0 0 0\n"
                              "MouseMoveEvent 216 287 0 0 0 0 0\n"
                              "MouseMoveEvent 217 285 0 0 0 0 0\n"
                              "TimerEvent 217 285 0 0 0 0 0\n"
                              "RenderEvent 217 285 0 0 0 0 0\n"
                              "MouseMoveEvent 217 282 0 0 0 0 0\n"
                              "MouseMoveEvent 218 279 0 0 0 0 0\n"
                              "MouseMoveEvent 218 277 0 0 0 0 0\n"
                              "MouseMoveEvent 218 276 0 0 0 0 0\n"
                              "MouseMoveEvent 218 275 0 0 0 0 0\n"
                              "MouseMoveEvent 218 274 0 0 0 0 0\n"
                              "TimerEvent 218 274 0 0 0 0 0\n"
                              "RenderEvent 218 274 0 0 0 0 0\n"
                              "MouseMoveEvent 218 272 0 0 0 0 0\n"
                              "MouseMoveEvent 219 271 0 0 0 0 0\n"
                              "MouseMoveEvent 219 269 0 0 0 0 0\n"
                              "MouseMoveEvent 219 268 0 0 0 0 0\n"
                              "MouseMoveEvent 219 265 0 0 0 0 0\n"
                              "MouseMoveEvent 219 263 0 0 0 0 0\n"
                              "TimerEvent 219 263 0 0 0 0 0\n"
                              "RenderEvent 219 263 0 0 0 0 0\n"
                              "MouseMoveEvent 219 257 0 0 0 0 0\n"
                              "MouseMoveEvent 219 255 0 0 0 0 0\n"
                              "MouseMoveEvent 219 253 0 0 0 0 0\n"
                              "MouseMoveEvent 219 252 0 0 0 0 0\n"
                              "MouseMoveEvent 219 250 0 0 0 0 0\n"
                              "MouseMoveEvent 219 248 0 0 0 0 0\n"
                              "TimerEvent 219 248 0 0 0 0 0\n"
                              "RenderEvent 219 248 0 0 0 0 0\n"
                              "MouseMoveEvent 219 244 0 0 0 0 0\n"
                              "MouseMoveEvent 220 243 0 0 0 0 0\n"
                              "MouseMoveEvent 220 241 0 0 0 0 0\n"
                              "MouseMoveEvent 220 240 0 0 0 0 0\n"
                              "MouseMoveEvent 220 239 0 0 0 0 0\n"
                              "MouseMoveEvent 221 238 0 0 0 0 0\n"
                              "TimerEvent 221 238 0 0 0 0 0\n"
                              "RenderEvent 221 238 0 0 0 0 0\n"
                              "MouseMoveEvent 221 236 0 0 0 0 0\n"
                              "MouseMoveEvent 221 235 0 0 0 0 0\n"
                              "MouseMoveEvent 222 234 0 0 0 0 0\n"
                              "MouseMoveEvent 222 232 0 0 0 0 0\n"
                              "TimerEvent 222 232 0 0 0 0 0\n"
                              "RenderEvent 222 232 0 0 0 0 0\n"
                              "MouseMoveEvent 222 231 0 0 0 0 0\n"
                              "MouseMoveEvent 222 231 0 0 0 0 0\n"
                              "TimerEvent 222 231 0 0 0 0 0\n"
                              "RenderEvent 222 231 0 0 0 0 0\n"
                              "MouseMoveEvent 222 229 0 0 0 0 0\n"
                              "MouseMoveEvent 223 228 0 0 0 0 0\n"
                              "MouseMoveEvent 223 227 0 0 0 0 0\n"
                              "MouseMoveEvent 223 226 0 0 0 0 0\n"
                              "MouseMoveEvent 223 225 0 0 0 0 0\n"
                              "TimerEvent 223 225 0 0 0 0 0\n"
                              "RenderEvent 223 225 0 0 0 0 0\n"
                              "MouseMoveEvent 223 223 0 0 0 0 0\n"
                              "TimerEvent 223 223 0 0 0 0 0\n"
                              "RenderEvent 223 223 0 0 0 0 0\n"
                              "LeftButtonReleaseEvent 223 223 0 0 0 0 0\n"
                              "TimerEvent 223 223 0 0 0 0 0\n"
                              "RenderEvent 223 223 0 0 0 0 0\n"
                              "MouseMoveEvent 223 222 0 0 0 0 0\n"
                              "MouseMoveEvent 223 220 0 0 0 0 0\n"
                              "MouseMoveEvent 223 217 0 0 0 0 0\n"
                              "MouseMoveEvent 222 213 0 0 0 0 0\n"
                              "MouseMoveEvent 221 211 0 0 0 0 0\n"
                              "MouseMoveEvent 220 208 0 0 0 0 0\n"
                              "MouseMoveEvent 219 207 0 0 0 0 0\n"
                              "MouseMoveEvent 219 206 0 0 0 0 0\n"
                              "MouseMoveEvent 219 205 0 0 0 0 0\n"
                              "MouseMoveEvent 219 204 0 0 0 0 0\n"
                              "MouseMoveEvent 219 203 0 0 0 0 0\n"
                              "MouseMoveEvent 219 203 0 0 0 0 0\n"
                              "MouseMoveEvent 217 201 0 0 0 0 0\n"
                              "MouseMoveEvent 216 200 0 0 0 0 0\n"
                              "KeyPressEvent 216 200 0 0 1 Control_L 0\n"
                              "CharEvent 216 200 0 0 1 Control_L 0\n"
                              "MouseMoveEvent 216 199 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 199 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 198 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 197 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 196 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 194 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 193 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 192 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 191 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 189 2 0 0 Control_L 0\n"
                              "LeftButtonPressEvent 216 189 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 187 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 184 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 182 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 179 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 176 2 0 0 Control_L 0\n"
                              "TimerEvent 216 176 2 0 0 Control_L 0\n"
                              "RenderEvent 216 176 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 215 170 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 214 168 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 214 165 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 214 163 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 214 161 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 158 2 0 0 Control_L 0\n"
                              "TimerEvent 213 158 2 0 0 Control_L 0\n"
                              "RenderEvent 213 158 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 156 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 154 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 153 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 151 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 150 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 148 2 0 0 Control_L 0\n"
                              "TimerEvent 213 148 2 0 0 Control_L 0\n"
                              "RenderEvent 213 148 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 144 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 213 143 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 142 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 141 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 140 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 138 2 0 0 Control_L 0\n"
                              "TimerEvent 212 138 2 0 0 Control_L 0\n"
                              "RenderEvent 212 138 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 137 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 135 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 134 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 133 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 132 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 131 2 0 0 Control_L 0\n"
                              "TimerEvent 211 131 2 0 0 Control_L 0\n"
                              "RenderEvent 211 131 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 129 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 211 127 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 125 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 124 2 0 0 Control_L 0\n"
                              "TimerEvent 212 124 2 0 0 Control_L 0\n"
                              "RenderEvent 212 124 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 123 2 0 0 Control_L 0\n"
                              "TimerEvent 212 123 2 0 0 Control_L 0\n"
                              "RenderEvent 212 123 2 0 0 Control_L 0\n"
                              "LeftButtonReleaseEvent 212 123 2 0 0 Control_L 0\n"
                              "TimerEvent 212 123 2 0 0 Control_L 0\n"
                              "RenderEvent 212 123 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 212 123 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 215 123 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 123 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 121 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 119 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 225 118 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 229 116 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 231 114 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 233 112 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 235 110 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 236 109 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 238 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 239 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 240 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 239 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 238 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 237 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 237 107 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 237 108 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 237 109 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 237 110 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 236 111 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 235 113 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 234 114 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 233 116 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 233 118 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 233 121 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 231 122 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 230 125 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 228 127 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 228 129 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 227 132 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 227 134 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 226 137 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 226 139 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 225 142 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 225 144 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 225 146 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 148 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 152 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 155 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 158 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 222 160 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 221 163 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 164 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 166 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 168 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 170 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 172 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 173 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 175 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 178 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 179 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 182 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 185 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 188 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 190 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 192 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 194 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 195 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 196 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 197 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 198 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 199 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 200 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 201 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 217 202 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 203 2 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 203 2 0 0 Control_L 0\n"
                              "KeyReleaseEvent 218 203 2 0 1 Control_L 0\n"
                              "KeyPressEvent 218 203 0 0 1 Shift_L 0\n"
                              "CharEvent 218 203 0 0 1 Shift_L 0\n"
                              "LeftButtonPressEvent 218 203 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 203 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 219 203 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 202 1 0 0 Shift_L 0\n"
                              "TimerEvent 220 202 1 0 0 Shift_L 0\n"
                              "RenderEvent 220 202 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 201 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 200 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 199 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 198 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 198 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 198 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 196 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 195 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 194 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 194 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 194 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 194 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 193 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 192 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 191 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 191 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 191 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 190 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 189 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 188 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 187 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 186 1 0 0 Shift_L 0\n"
                              "TimerEvent 222 186 1 0 0 Shift_L 0\n"
                              "RenderEvent 222 186 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 185 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 184 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 184 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 184 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 183 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 181 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 180 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 179 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 177 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 176 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 176 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 176 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 174 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 173 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 172 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 172 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 172 1 0 0 Shift_L 0\n"
                              "LeftButtonReleaseEvent 221 172 1 0 0 Shift_L 0\n"
                              "TimerEvent 221 172 1 0 0 Shift_L 0\n"
                              "RenderEvent 221 172 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 172 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 172 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 223 172 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 224 172 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 224 172 1 0 0 Shift_L 0\n"
                              "KeyReleaseEvent 224 172 1 0 1 Shift_L 0\n"
                              "MouseMoveEvent 224 173 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 224 174 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 223 174 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 223 176 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 223 177 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 223 179 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 180 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 222 181 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 221 182 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 182 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 183 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 220 185 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 219 186 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 186 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 188 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 189 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 217 190 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 217 191 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 217 192 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 217 193 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 195 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 196 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 198 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 200 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 217 203 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 205 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 208 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 210 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 212 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 213 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 215 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 216 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 217 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 218 0 0 0 Shift_L 0\n"
                              "KeyPressEvent 218 218 0 0 1 Shift_L 0\n"
                              "CharEvent 218 218 0 0 1 Shift_L 0\n"
                              "MouseMoveEvent 218 218 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 219 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 220 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 224 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 218 227 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 232 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 237 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 242 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 247 1 0 0 Shift_L 0\n"
                              "MouseMoveEvent 216 252 1 0 0 Shift_L 0\n"
                              "KeyPressEvent 216 252 1 0 1 Control_L 0\n"
                              "CharEvent 216 252 1 0 1 Control_L 0\n"
                              "MouseMoveEvent 216 258 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 264 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 271 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 216 276 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 281 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 286 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 290 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 295 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 299 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 302 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 305 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 218 308 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 312 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 314 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 316 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 221 319 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 222 321 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 323 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 325 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 327 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 328 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 329 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 329 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 328 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 328 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 326 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 325 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 324 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 323 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 323 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 322 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 322 3 0 0 Control_L 0\n"
                              "LeftButtonPressEvent 223 322 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 321 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 320 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 222 318 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 222 317 3 0 0 Control_L 0\n"
                              "TimerEvent 222 317 3 0 0 Control_L 0\n"
                              "RenderEvent 222 317 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 312 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 310 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 309 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 307 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 305 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 303 3 0 0 Control_L 0\n"
                              "TimerEvent 219 303 3 0 0 Control_L 0\n"
                              "RenderEvent 219 303 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 300 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 298 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 296 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 295 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 294 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 292 3 0 0 Control_L 0\n"
                              "TimerEvent 219 292 3 0 0 Control_L 0\n"
                              "RenderEvent 219 292 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 289 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 288 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 286 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 285 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 283 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 281 3 0 0 Control_L 0\n"
                              "TimerEvent 219 281 3 0 0 Control_L 0\n"
                              "RenderEvent 219 281 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 276 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 274 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 273 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 272 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 270 3 0 0 Control_L 0\n"
                              "TimerEvent 219 270 3 0 0 Control_L 0\n"
                              "RenderEvent 219 270 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 265 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 263 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 262 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 260 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 258 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 256 3 0 0 Control_L 0\n"
                              "TimerEvent 219 256 3 0 0 Control_L 0\n"
                              "RenderEvent 219 256 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 253 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 251 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 250 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 248 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 247 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 246 3 0 0 Control_L 0\n"
                              "TimerEvent 219 246 3 0 0 Control_L 0\n"
                              "RenderEvent 219 246 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 244 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 243 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 241 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 240 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 239 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 219 237 3 0 0 Control_L 0\n"
                              "TimerEvent 219 237 3 0 0 Control_L 0\n"
                              "RenderEvent 219 237 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 233 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 232 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 231 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 230 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 229 3 0 0 Control_L 0\n"
                              "TimerEvent 220 229 3 0 0 Control_L 0\n"
                              "RenderEvent 220 229 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 226 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 225 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 224 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 223 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 222 3 0 0 Control_L 0\n"
                              "TimerEvent 220 222 3 0 0 Control_L 0\n"
                              "RenderEvent 220 222 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 221 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 220 3 0 0 Control_L 0\n"
                              "TimerEvent 220 220 3 0 0 Control_L 0\n"
                              "RenderEvent 220 220 3 0 0 Control_L 0\n"
                              "LeftButtonReleaseEvent 220 220 3 0 0 Control_L 0\n"
                              "TimerEvent 220 220 3 0 0 Control_L 0\n"
                              "RenderEvent 220 220 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 220 220 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 221 220 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 222 219 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 223 218 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 224 218 3 0 0 Control_L 0\n"
                              "MouseMoveEvent 225 217 3 0 0 Control_L 0\n"
                              "KeyReleaseEvent 225 217 3 0 1 Control_L 0\n"
                              "KeyReleaseEvent 225 217 1 0 1 Shift_L 0\n"
                              "MouseMoveEvent 226 217 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 226 217 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 227 217 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 228 218 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 229 219 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 230 220 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 230 221 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 231 221 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 232 222 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 233 223 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 234 223 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 235 224 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 236 225 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 240 226 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 243 227 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 246 229 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 252 230 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 257 233 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 261 234 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 266 236 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 275 238 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 285 241 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 293 243 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 300 246 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 310 248 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 319 251 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 329 256 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 338 258 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 345 260 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 354 261 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 358 262 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 367 265 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 371 266 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 373 267 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 376 268 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 377 269 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 377 270 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 377 270 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 376 270 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 375 269 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 380 270 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 382 271 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 385 272 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 388 273 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 391 276 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 394 278 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 397 281 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 399 281 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 400 282 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 403 284 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 405 284 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 408 286 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 409 288 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 413 290 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 415 291 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 418 293 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 419 295 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 423 297 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 425 298 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 426 300 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 428 301 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 429 302 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 431 304 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 435 306 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 439 309 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 444 314 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 450 318 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 456 323 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 463 329 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 470 334 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 478 341 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 482 344 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 488 348 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 494 352 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 499 356 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 506 361 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 512 365 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 518 369 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 523 373 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 526 376 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 531 379 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 534 382 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 537 384 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 538 387 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 540 388 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 540 390 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 540 391 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 542 392 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 542 393 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 541 394 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 539 395 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 537 395 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 533 395 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 529 396 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 523 396 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 516 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 508 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 499 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 487 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 477 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 464 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 454 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 447 397 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 438 398 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 432 398 0 0 0 Shift_L 0\n"
                              "MouseMoveEvent 428 398 0 0 0 Shift_L 0\n"
                              "LeaveEvent 425 400 0 0 0 Shift_L 0\n";

int TestParallelCoordinatesSelection(int vtkNotUsed(argc), char* vtkNotUsed(argv)[])
{
  // Set up a 2D scene, add an parallel coordinate chart to it
  vtkNew<vtkContextView> view;
  view->GetRenderWindow()->SetWindowName("TestParallelCoordinateSelection");
  view->GetRenderWindow()->SetSize(600, 400);
  view->GetRenderWindow()->SetMultiSamples(0);
  vtkNew<vtkChartParallelCoordinates> chart;
  view->GetScene()->AddItem(chart);

  // Create a table with some points in it...
  vtkNew<vtkTable> table;
  vtkNew<vtkDoubleArray> arrX;
  arrX->SetName("x");
  table->AddColumn(arrX);
  vtkNew<vtkDoubleArray> arrC;
  arrC->SetName("cosine");
  table->AddColumn(arrC);
  vtkNew<vtkDoubleArray> arrS;
  arrS->SetName("sine");
  table->AddColumn(arrS);
  vtkNew<vtkDoubleArray> arrS2;
  arrS2->SetName("tangent");
  table->AddColumn(arrS2);

  int numPoints = 200;
  float inc = 7.5 / (numPoints - 1);
  table->SetNumberOfRows(numPoints);
  for (int i = 0; i < numPoints; ++i)
  {
    table->SetValue(i, 0, i * inc);
    table->SetValue(i, 1, cos(i * inc));
    table->SetValue(i, 2, sin(i * inc));
    table->SetValue(i, 3, tan(i * inc) + 0.5);
  }
  chart->GetPlot(0)->SetInputData(table);

  // record events
  vtkSmartPointer<vtkInteractorEventRecorder> recorder =
    vtkSmartPointer<vtkInteractorEventRecorder>::New();
  view->GetInteractor()->Initialize();
  recorder->SetInteractor(view->GetInteractor());

#ifdef RECORD_TESTING
  recorder->SetFileName("record.txt");
  recorder->SetEnabled(true);
  recorder->Record();
  view->GetInteractor()->Start();
#else
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(eventLog);
  recorder->Play();
#endif

  if (chart->GetNumberOfPlots() != 1)
  {
    std::cerr << "Wrong number of plot. Expected 1 but got " << chart->GetNumberOfPlots()
              << std::endl;
    return EXIT_FAILURE;
  }

  auto ids = chart->GetPlot(0)->GetSelection();
  if (!ids)
  {
    std::cerr << "Selection shouldn't be null" << std::endl;
    return EXIT_FAILURE;
  }

  if (ids->GetSize() != 31)
  {
    std::cerr << "Wrong number of id selection. Expected to have 14 ids but got " << ids->GetSize()
              << std::endl;
    return EXIT_FAILURE;
  }

  for (int i = 0; i < ids->GetSize(); i++)
  {
    if (ids->GetValue(i) != expectedValues[i])
    {
      std::cerr << "Wrong id values in the current selection. Expected to have "
                << expectedValues[i] << " id but got " << ids->GetValue(i) << std::endl;
      return EXIT_FAILURE;
    }
  }

  return EXIT_SUCCESS;
}
