/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.web3d.parser.x3d.JavaCharStream;
import org.web3d.parser.x3d.ParseException;
import org.web3d.parser.x3d.Token;
import org.web3d.parser.x3d.X3DRelaxedParserConstants;
import org.web3d.parser.x3d.X3DRelaxedParserTokenManager;
import org.web3d.util.ErrorReporter;
import org.web3d.util.StringArray;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;

public class X3DRelaxedParser
implements X3DRelaxedParserConstants {
    private static final String PARSE_MSG = "Parsing error: ";
    private static final String PROFILE_MSG = "PROFILE declaration error: ";
    private static final String COMPONENT_MSG = "COMPONENT declaration error: ";
    private static final String META_MSG = "META declaration error: ";
    private static final int DEFAULT_ARRAY_SIZE = 4096;
    private static final int DEFAULT_ARRAY_INC = 1024;
    private String documentURL;
    private StringContentHandler contentHandler;
    private RouteHandler routeHandler;
    private ScriptHandler scriptHandler;
    private ProtoHandler protoHandler;
    private ErrorReporter errorHandler;
    private Locator locator;
    private StringArray stringArray;
    public X3DRelaxedParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[38];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[5];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public X3DRelaxedParser(InputStream inputStream, ContentHandler contentHandler, RouteHandler routeHandler, ScriptHandler scriptHandler, ProtoHandler protoHandler, ErrorHandler errorHandler) {
        this(inputStream);
        this.locator = new VRMLRelaxedLocator();
        this.stringArray = new StringArray(4096, 1024);
        this.contentHandler = (StringContentHandler)contentHandler;
        this.routeHandler = routeHandler;
        this.scriptHandler = scriptHandler;
        this.protoHandler = protoHandler;
        this.errorHandler = errorHandler;
    }

    public X3DRelaxedParser(Reader reader, ContentHandler contentHandler, RouteHandler routeHandler, ScriptHandler scriptHandler, ProtoHandler protoHandler, ErrorHandler errorHandler) {
        this(reader);
        this.locator = new VRMLRelaxedLocator();
        this.stringArray = new StringArray(4096, 1024);
        this.contentHandler = (StringContentHandler)contentHandler;
        this.routeHandler = routeHandler;
        this.scriptHandler = scriptHandler;
        this.protoHandler = protoHandler;
        this.errorHandler = errorHandler;
    }

    public void initialize() {
        if (this.locator == null) {
            this.locator = new VRMLRelaxedLocator();
        }
        this.stringArray = new StringArray(4096, 1024);
    }

    public void setDocumentUrl(String string) {
        this.documentURL = string;
    }

    public Locator getDocumentLocator() {
        if (this.locator == null) {
            this.locator = new VRMLRelaxedLocator();
        }
        return this.locator;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = (StringContentHandler)contentHandler;
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        this.routeHandler = routeHandler;
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        this.scriptHandler = scriptHandler;
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        this.protoHandler = protoHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (errorHandler != null) {
            errorHandler.setDocumentLocator(this.getDocumentLocator());
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter instanceof ErrorHandler) {
            this.setErrorHandler((ErrorHandler)errorReporter);
        } else {
            this.errorHandler = errorReporter;
        }
    }

    private void convertException(VRMLException vRMLException) throws ParseException {
        boolean bl = false;
        if (vRMLException instanceof InvalidFieldException || vRMLException instanceof InvalidFieldValueException) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.warningReport(PARSE_MSG, vRMLException);
                    bl = true;
                }
                catch (VRMLException vRMLException2) {
                    vRMLException = vRMLException2;
                }
            }
        } else if (this.errorHandler != null) {
            try {
                this.errorHandler.errorReport(PARSE_MSG, vRMLException);
                bl = true;
            }
            catch (VRMLException vRMLException3) {
                vRMLException = vRMLException3;
            }
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("There's an error in the file:\n");
            stringBuffer.append(this.documentURL);
            stringBuffer.append('\n');
            String string = vRMLException.getMessage();
            if (string == null) {
                string = vRMLException.getClass().getName();
            }
            stringBuffer.append(string);
            stringBuffer.append('\n');
            throw new ParseException(stringBuffer.toString());
        }
    }

    private String stripString() {
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Scene() throws ParseException {
        try {
            this.Header();
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: 
                    case 18: 
                    case 21: 
                    case 26: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 39: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block6;
                    }
                }
                this.Statement();
            }
            this.jj_consume_token(0);
        }
        finally {
            this.documentURL = null;
        }
    }

    public final void Header() throws ParseException {
        this.ProfileDecl();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block6;
                }
            }
            this.ComponentDecl();
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block7;
                }
            }
            this.MetaDecl();
        }
    }

    public final void ProfileDecl() throws ParseException {
        this.jj_consume_token(31);
        String string = this.Id();
        if (this.contentHandler != null) {
            try {
                this.contentHandler.profileDecl(string);
            }
            catch (VRMLException vRMLException) {
                if (this.errorHandler != null) {
                    try {
                        this.errorHandler.warningReport(PROFILE_MSG, vRMLException);
                    }
                    catch (VRMLException vRMLException2) {
                        this.convertException(vRMLException2);
                    }
                }
                this.convertException(vRMLException);
            }
        }
    }

    public final void ComponentDecl() throws ParseException {
        this.jj_consume_token(32);
        String string = this.Id();
        if (this.contentHandler != null) {
            try {
                this.contentHandler.componentDecl(string);
            }
            catch (VRMLException vRMLException) {
                if (this.errorHandler != null) {
                    try {
                        this.errorHandler.warningReport(COMPONENT_MSG, vRMLException);
                    }
                    catch (VRMLException vRMLException2) {
                        this.convertException(vRMLException2);
                    }
                }
                this.convertException(vRMLException);
            }
        }
    }

    public final void MetaDecl() throws ParseException {
        this.jj_consume_token(20);
        this.jj_consume_token(12);
        String string = this.stripString();
        this.jj_consume_token(12);
        String string2 = this.stripString();
        if (this.contentHandler != null) {
            try {
                this.contentHandler.metaDecl(string, string2);
            }
            catch (VRMLException vRMLException) {
                if (this.errorHandler != null) {
                    try {
                        this.errorHandler.warningReport(META_MSG, vRMLException);
                    }
                    catch (VRMLException vRMLException2) {
                        this.convertException(vRMLException2);
                    }
                }
                this.convertException(vRMLException);
            }
        }
    }

    public final void Statement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 18: 
            case 36: 
            case 39: {
                this.NodeStatement();
                break;
            }
            case 21: 
            case 26: {
                this.ProtoStatement();
                break;
            }
            case 27: {
                this.RouteStatement();
                break;
            }
            case 34: {
                this.ImportStatement();
                break;
            }
            case 33: {
                this.ExportStatement();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ProtoBodyStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 18: 
            case 36: 
            case 39: {
                this.NodeStatement();
                break;
            }
            case 21: 
            case 26: {
                this.ProtoStatement();
                break;
            }
            case 27: {
                this.RouteStatement();
                break;
            }
            case 34: {
                this.ImportStatement();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                throw new ParseException("Cannot use EXPORT statements in a proto body declaration");
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void NodeStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 39: {
                this.Node(null);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                String string = this.NodeNameId();
                this.Node(string);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                String string = this.NodeNameId();
                if (this.contentHandler == null) break;
                try {
                    this.contentHandler.useDecl(string);
                }
                catch (VRMLException vRMLException) {
                    if (this.errorHandler != null) {
                        try {
                            this.errorHandler.warningReport(PARSE_MSG, vRMLException);
                        }
                        catch (VRMLException vRMLException2) {
                            this.convertException(vRMLException2);
                        }
                        break;
                    }
                    this.convertException(vRMLException);
                }
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void RootNodeStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 39: {
                this.Node(null);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                String string = this.NodeNameId();
                this.Node(string);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ProtoStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.Proto();
                break;
            }
            case 26: {
                this.ExternProto();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Proto() throws ParseException {
        try {
            this.jj_consume_token(21);
            String string = this.NodeTypeId();
            this.jj_consume_token(15);
            if (this.protoHandler != null) {
                this.protoHandler.startProtoDecl(string);
            }
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block5;
                    }
                }
                this.InterfaceDecl();
            }
            this.jj_consume_token(16);
            if (this.protoHandler != null) {
                this.protoHandler.endProtoDecl();
            }
            this.jj_consume_token(13);
            if (this.protoHandler != null) {
                this.protoHandler.startProtoBody();
            }
            this.ProtoBody();
            this.jj_consume_token(14);
            if (this.protoHandler != null) {
                this.protoHandler.endProtoBody();
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void ProtoBody() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block6;
                }
            }
            this.ProtoStatement();
        }
        this.RootNodeStatement();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 18: 
                case 21: 
                case 26: 
                case 27: 
                case 33: 
                case 34: 
                case 36: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block7;
                }
            }
            this.ProtoBodyStatement();
        }
    }

    public final void RestrictedInterfaceDecl() throws ParseException {
        Object object = null;
        boolean bl = false;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    int n = 1;
                    String string = this.FieldId();
                    String string2 = this.FieldNameId();
                    if (this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string2, object);
                    }
                    break;
                }
                case 23: {
                    this.jj_consume_token(23);
                    int n = 4;
                    String string = this.FieldId();
                    String string3 = this.FieldNameId();
                    if (this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string3, object);
                    }
                    break;
                }
                case 24: {
                    this.jj_consume_token(24);
                    int n = 2;
                    String string = this.FieldId();
                    String string4 = this.FieldNameId();
                    if (string.endsWith("FNode")) {
                        bl = true;
                        if (this.protoHandler != null) {
                            this.protoHandler.protoFieldDecl(n, string, string4, null);
                        }
                    }
                    object = this.FieldValue(string4);
                    if (!bl && this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string4, object);
                    }
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void InterfaceDecl() throws ParseException {
        Object object = null;
        boolean bl = false;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 23: 
                case 24: {
                    this.RestrictedInterfaceDecl();
                    break;
                }
                case 25: {
                    this.jj_consume_token(25);
                    int n = 3;
                    String string = this.FieldId();
                    String string2 = this.FieldNameId();
                    if (string.endsWith("FNode")) {
                        bl = true;
                        if (this.protoHandler != null) {
                            this.protoHandler.protoFieldDecl(n, string, string2, null);
                        }
                    }
                    object = this.FieldValue(string2);
                    if (!bl && this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string2, object);
                    }
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void ExternProto() throws ParseException {
        try {
            this.jj_consume_token(26);
            String string = this.NodeTypeId();
            this.jj_consume_token(15);
            if (this.protoHandler != null) {
                this.protoHandler.startExternProtoDecl(string);
            }
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block5;
                    }
                }
                this.ExternInterfaceDecl();
            }
            this.jj_consume_token(16);
            if (this.protoHandler != null) {
                this.protoHandler.endExternProtoDecl();
            }
            String[] stringArray = this.URIList();
            if (this.protoHandler != null) {
                this.protoHandler.externProtoURI(stringArray);
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void ExternInterfaceDecl() throws ParseException {
        int n = this.AccessType();
        String string = this.FieldId();
        String string2 = this.FieldNameId();
        if (this.protoHandler != null) {
            try {
                this.protoHandler.protoFieldDecl(n, string, string2, null);
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final void RouteStatement() throws ParseException {
        this.jj_consume_token(27);
        String string = this.NodeNameId();
        this.jj_consume_token(30);
        String string2 = this.FieldNameId();
        this.jj_consume_token(28);
        String string3 = this.NodeNameId();
        this.jj_consume_token(30);
        String string4 = this.FieldNameId();
        if (this.routeHandler != null) {
            try {
                this.routeHandler.routeDecl(string, string2, string3, string4);
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final void ImportStatement() throws ParseException {
        String string = null;
        this.jj_consume_token(34);
        String string2 = this.NodeNameId();
        this.jj_consume_token(30);
        String string3 = this.NodeNameId();
        block5: while (true) {
            this.jj_consume_token(35);
            string = this.NodeNameId();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    continue block5;
                }
            }
            break;
        }
        this.jj_la1[14] = this.jj_gen;
        if (this.contentHandler != null) {
            try {
                if (string == null) {
                    string = string3;
                }
                this.contentHandler.importDecl(string2, string3, string);
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final void ExportStatement() throws ParseException {
        String string = null;
        this.jj_consume_token(33);
        String string2 = this.NodeNameId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                string = this.NodeNameId();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        if (this.contentHandler != null) {
            try {
                if (string == null) {
                    string = string2;
                }
                this.contentHandler.exportDecl(string2, string);
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final String[] URIList() throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(12);
                    arrayList.add(this.stripString());
                }
                this.jj_consume_token(16);
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
            case 12: {
                this.jj_consume_token(12);
                return new String[]{this.stripString()};
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Node(String string) throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: {
                    String string2 = this.Id();
                    this.jj_consume_token(13);
                    if (this.contentHandler != null) {
                        this.contentHandler.startNode(string2, string);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 26: 
                        case 27: 
                        case 39: {
                            this.NodeBody();
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(14);
                    if (this.contentHandler != null) {
                        this.contentHandler.endNode();
                    }
                    break;
                }
                case 36: {
                    this.jj_consume_token(36);
                    this.jj_consume_token(13);
                    if (this.contentHandler != null) {
                        this.contentHandler.startNode("Script", string);
                    }
                    if (this.scriptHandler != null) {
                        this.scriptHandler.startScriptDecl();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 39: {
                            this.ScriptBody();
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(14);
                    if (this.scriptHandler != null) {
                        this.scriptHandler.endScriptDecl();
                    }
                    if (this.contentHandler != null) {
                        this.contentHandler.endNode();
                    }
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void NodeBody() throws ParseException {
        block3: while (true) {
            this.NodeBodyElement();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 26: 
                case 27: 
                case 39: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[21] = this.jj_gen;
    }

    public final void NodeBodyElement() throws ParseException {
        block20: {
            boolean bl = false;
            try {
                if (this.jj_2_1(2)) {
                    String string = this.FieldNameId();
                    if (this.contentHandler != null) {
                        try {
                            this.contentHandler.startField(string);
                            bl = false;
                        }
                        catch (VRMLException vRMLException) {
                            bl = true;
                            this.convertException(vRMLException);
                        }
                    }
                    Object object = this.FieldValue(null);
                    if (!bl && object != null && this.contentHandler != null) {
                        if (object instanceof String) {
                            this.contentHandler.fieldValue((String)object);
                        } else {
                            this.contentHandler.fieldValue((String[])object);
                        }
                    }
                    break block20;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        String string = this.FieldNameId();
                        if (this.contentHandler != null) {
                            try {
                                this.contentHandler.startField(string);
                                bl = false;
                            }
                            catch (VRMLException vRMLException) {
                                bl = true;
                                this.convertException(vRMLException);
                            }
                        }
                        this.jj_consume_token(29);
                        String string2 = this.FieldNameId();
                        if (this.protoHandler != null && !bl) {
                            try {
                                this.protoHandler.protoIsDecl(string2);
                            }
                            catch (FieldException fieldException) {
                                this.convertException(fieldException);
                            }
                        }
                        break;
                    }
                    case 27: {
                        this.RouteStatement();
                        break;
                    }
                    case 21: 
                    case 26: {
                        this.ProtoStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final void ScriptBody() throws ParseException {
        block3: while (true) {
            this.ScriptBodyElement();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 39: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[23] = this.jj_gen;
    }

    public final void ScriptBodyElement() throws ParseException {
        block31: {
            boolean bl = false;
            try {
                if (this.jj_2_2(3)) {
                    this.NodeBodyElement();
                    break block31;
                }
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        int n = 1;
                        String string = this.FieldId();
                        String string2 = this.FieldNameId();
                        if (this.scriptHandler != null) {
                            this.scriptHandler.scriptFieldDecl(n, string, string2, null);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 29: {
                                this.jj_consume_token(29);
                                String string3 = this.FieldNameId();
                                if (this.protoHandler != null) {
                                    this.protoHandler.protoIsDecl(string3);
                                    break;
                                }
                                break block31;
                            }
                            default: {
                                this.jj_la1[24] = this.jj_gen;
                                break;
                            }
                        }
                        break;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        int n = 4;
                        String string = this.FieldId();
                        String string4 = this.FieldNameId();
                        if (this.scriptHandler != null) {
                            this.scriptHandler.scriptFieldDecl(n, string, string4, null);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 29: {
                                this.jj_consume_token(29);
                                String string5 = this.FieldNameId();
                                if (this.protoHandler != null) {
                                    this.protoHandler.protoIsDecl(string5);
                                    break;
                                }
                                break block31;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                break;
                            }
                        }
                        break;
                    }
                    case 24: 
                    case 25: {
                        int n;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 24: {
                                this.jj_consume_token(24);
                                n = 2;
                                break;
                            }
                            case 25: {
                                this.jj_consume_token(25);
                                n = 3;
                                break;
                            }
                            default: {
                                this.jj_la1[26] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        String string = this.FieldId();
                        String string6 = this.FieldNameId();
                        if (string.endsWith("FNode")) {
                            bl = true;
                            if (this.scriptHandler != null) {
                                this.scriptHandler.scriptFieldDecl(n, string, string6, null);
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 29: {
                                this.jj_consume_token(29);
                                String string7 = this.FieldNameId();
                                if (this.scriptHandler != null && !bl) {
                                    this.scriptHandler.scriptFieldDecl(n, string, string6, null);
                                }
                                if (this.protoHandler != null) {
                                    this.protoHandler.protoIsDecl(string7);
                                    break block1;
                                }
                                break block31;
                            }
                            case 11: 
                            case 12: 
                            case 15: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: {
                                Object object = this.FieldValue(string6);
                                if (!bl && this.scriptHandler != null) {
                                    this.scriptHandler.scriptFieldDecl(n, string, string6, object);
                                    break block1;
                                }
                                break block31;
                            }
                            default: {
                                this.jj_la1[27] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final String NodeNameId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final String NodeTypeId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final String FieldNameId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final int AccessType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                return 2;
            }
            case 22: {
                this.jj_consume_token(22);
                return 1;
            }
            case 23: {
                this.jj_consume_token(23);
                return 4;
            }
            case 25: {
                this.jj_consume_token(25);
                return 3;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String FieldId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final Object FieldValue(String string) throws ParseException {
        Object object = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                object = this.SingleFieldValue();
                break;
            }
            case 15: {
                object = this.MultiFieldValue(string);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object;
    }

    public final String SingleFieldValue() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 18: 
            case 36: 
            case 39: {
                this.NodeStatement();
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                string = this.token.image;
                break;
            }
            case 11: 
            case 12: 
            case 37: 
            case 38: {
                string = this.LiteralValue();
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final Object MultiFieldValue(String string) throws ParseException {
        boolean bl = false;
        Object var3_3 = null;
        String[] stringArray = null;
        ArrayList arrayList = new ArrayList();
        try {
            this.jj_consume_token(15);
            if (this.jj_2_3(2)) {
                block9: while (true) {
                    this.NodeStatement();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: 
                        case 18: 
                        case 36: 
                        case 39: {
                            continue block9;
                        }
                    }
                    break;
                }
                this.jj_la1[32] = this.jj_gen;
                bl = true;
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        stringArray = this.NumberArray();
                        break;
                    }
                    case 37: 
                    case 38: {
                        stringArray = this.BooleanArray();
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        stringArray = this.StringArray();
                    }
                }
            }
            this.jj_consume_token(16);
            if (this.contentHandler != null) {
                if (bl) {
                    this.contentHandler.endField();
                } else {
                    return stringArray;
                }
            }
            return null;
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
            throw new Error("Missing return statement in function");
        }
    }

    public final String LiteralValue() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                string = this.token.image;
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                string = this.token.image;
                break;
            }
            case 11: {
                string = this.FixedNumberArray();
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                string = this.token.image;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final String[] StringArray() throws ParseException {
        this.stringArray.clear();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            this.stringArray.add(this.token.image);
        }
        return this.stringArray.toArray();
    }

    public final String[] NumberArray() throws ParseException {
        this.stringArray.clear();
        do {
            this.jj_consume_token(11);
            this.stringArray.add(this.token.image);
        } while (this.jj_2_4(2));
        return this.stringArray.toArray();
    }

    public final String FixedNumberArray() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            this.jj_consume_token(11);
            stringBuffer.append(' ');
            stringBuffer.append(this.token.image);
        } while (this.jj_2_5(2));
        return stringBuffer.toString();
    }

    public final String[] BooleanArray() throws ParseException {
        this.stringArray.clear();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    this.jj_consume_token(37);
                    this.stringArray.add(this.token.image);
                    break;
                }
                case 38: {
                    this.jj_consume_token(38);
                    this.stringArray.add(this.token.image);
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 38: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[37] = this.jj_gen;
        return this.stringArray.toArray();
    }

    public final String Id() throws ParseException {
        this.jj_consume_token(39);
        return this.token.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    private final boolean jj_3R_19() {
        Token token = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = token;
            if (this.jj_3R_24()) {
                this.jj_scanpos = token;
                if (this.jj_3R_25()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_26()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_31() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = token;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_43();
    }

    private final boolean jj_3_5() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_55() {
        Token token;
        if (this.jj_3_5()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_58();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_27();
    }

    private final boolean jj_3_3() {
        Token token;
        if (this.jj_3R_20()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_20());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_26() {
        return this.jj_3R_31();
    }

    private final boolean jj_3_4() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_56() {
        Token token;
        if (this.jj_3_4()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = token;
            if (this.jj_3R_51()) {
                this.jj_scanpos = token;
                if (this.jj_3R_52()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_53()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_24() {
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_42();
    }

    private final boolean jj_3R_58() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_60());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_27() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = token;
            if (this.jj_3R_33()) {
                this.jj_scanpos = token;
                if (this.jj_3R_34()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_41();
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_41() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = token;
            if (this.jj_3R_46()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_28() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = token;
            if (this.jj_3R_36()) {
                this.jj_scanpos = token;
                if (this.jj_3R_37()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_62() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_50() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_48() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_47() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3R_61() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3R_59() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = token;
            if (this.jj_3R_62()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_21();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_42() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = token;
            if (this.jj_3R_48()) {
                this.jj_scanpos = token;
                if (this.jj_3R_49()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_50()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_57() {
        Token token;
        if (this.jj_3R_59()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_59());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_29();
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_28();
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_3R_18();
    }

    private final boolean jj_3R_18() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = token;
            if (this.jj_3R_23()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{203816960, 0, 0x100000, 203816960, 203816960, 393216, 131072, 0x4200000, 0x3C00000, 0x4200000, 203816960, 0x1C00000, 0x3C00000, 0x3C00000, 0, 0, 4096, 36864, 0xC200000, 0xFE00000, 0, 0xC200000, 0xC200000, 0xFE00000, 0x20000000, 0x20000000, 0x3000000, 537827328, 0x3C00000, 0x3C00000, 956416, 923648, 393216, 2048, 6144, 4096, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{150, 1, 0, 150, 150, 144, 144, 0, 0, 0, 150, 0, 0, 0, 8, 8, 0, 0, 128, 128, 144, 128, 128, 128, 0, 0, 0, 240, 0, 0, 240, 240, 144, 96, 96, 0, 96, 96};
    }

    public X3DRelaxedParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public X3DRelaxedParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new X3DRelaxedParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 38; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 38; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public X3DRelaxedParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new X3DRelaxedParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 38; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 38; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public X3DRelaxedParser(X3DRelaxedParserTokenManager x3DRelaxedParserTokenManager) {
        int n;
        this.token_source = x3DRelaxedParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 38; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(X3DRelaxedParserTokenManager x3DRelaxedParserTokenManager) {
        int n;
        this.token_source = x3DRelaxedParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 38; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[42];
        for (n2 = 0; n2 < 42; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 38; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 42; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 5; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        X3DRelaxedParser.jj_la1_0();
        X3DRelaxedParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private class VRMLRelaxedLocator
    implements Locator {
        private VRMLRelaxedLocator() {
        }

        public int getColumnNumber() {
            return X3DRelaxedParser.this.token.beginColumn;
        }

        public int getLineNumber() {
            return X3DRelaxedParser.this.token.beginLine;
        }
    }
}

