catch {load vtktcl}
# demonstrates the use of vtkPropAssembly
# include get the vtk interactor ui
source ../../examplesTcl/vtkInt.tcl

# create four parts: a top level assembly and three primitives
#
vtkSphereSource sphere
vtkPolyDataMapper sphereMapper
    sphereMapper SetInput [sphere GetOutput]
vtkActor sphereActor
    sphereActor SetMapper sphereMapper
    sphereActor SetOrigin 2 1 3
    sphereActor RotateY 6
    sphereActor SetPosition 2.25 0 0
    [sphereActor GetProperty] SetColor 1 0 1

vtkCubeSource cube
vtkPolyDataMapper cubeMapper
    cubeMapper SetInput [cube GetOutput]
vtkActor cubeActor
    cubeActor SetMapper cubeMapper
    cubeActor SetPosition 0.0 .25 0
    [cubeActor GetProperty] SetColor 0 0 1

vtkConeSource cone
vtkPolyDataMapper coneMapper
    coneMapper SetInput [cone GetOutput]
vtkActor coneActor
    coneActor SetMapper coneMapper
    coneActor SetPosition 0 0 .25
    [coneActor GetProperty] SetColor 0 1 0

vtkCylinderSource cylinder;#top part
vtkPolyDataMapper cylinderMapper
    cylinderMapper SetInput [cylinder GetOutput]
vtkAssembly cylinderActor
    cylinderActor SetMapper cylinderMapper
    cylinderActor AddPart sphereActor
    cylinderActor AddPart cubeActor
    cylinderActor AddPart coneActor
    cylinderActor SetOrigin 5 10 15
    cylinderActor AddPosition 5 0 0
    cylinderActor RotateX 15
    [cylinderActor GetProperty] SetColor 1 0 0

# Build the prop assembly out of a vtkActor and a vtkAssembly
vtkPropAssembly assembly
  assembly AddPart cylinderActor
  assembly AddPart coneActor

# Create the RenderWindow, Renderer and both Actors
#
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

# Add the actors to the renderer, set the background and size
#
ren1 AddProp assembly
ren1 SetBackground 0.1 0.2 0.4
renWin SetSize 450 450

# Get handles to some useful objects
#
iren SetUserMethod {wm deiconify .vtkInteract}
iren Initialize
renWin Render

# should create the same image as assembly.tcl
renWin SetFileName propAssembly.tcl.ppm
#renWin SaveImageAsPPM

# prevent the tk window from showing up then start the event loop
wm withdraw .


