catch {load vtktcl}
# get the interactor ui
source ../../examplesTcl/vtkInt.tcl
source ../../examplesTcl/colors.tcl

# Create the RenderWindow, Renderer and both Actors
#
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

# create pipeline
#
vtkStructuredPointsReader reader
    reader SetFileName "../../../vtkdata/carotid.vtk"
vtkHedgeHog hhog
    hhog SetInput [reader GetOutput]
    hhog SetScaleFactor 0.3
vtkLookupTable lut
#    lut SetHueRange .667 0.0
    lut Build
vtkPolyDataMapper hhogMapper
    hhogMapper SetInput [hhog GetOutput]
    hhogMapper SetScalarRange 50 550
    hhogMapper SetLookupTable lut
    hhogMapper ImmediateModeRenderingOn

vtkActor hhogActor
    hhogActor SetMapper hhogMapper

vtkOutlineFilter outline
    outline SetInput [reader GetOutput]
vtkPolyDataMapper outlineMapper
    outlineMapper SetInput [outline GetOutput]
vtkActor outlineActor
    outlineActor SetMapper outlineMapper
set outlineProp [outlineActor GetProperty]
#eval $outlineProp SetColor 0 0 0

# Add the actors to the renderer, set the background and size
#
ren1 AddActor outlineActor
ren1 AddActor hhogActor
ren1 SetBackground 1 1 1
renWin SetSize 500 500
#renWin SetSize 1000 1000
ren1 SetBackground 0.1 0.2 0.4
iren Initialize

# render the image
#
iren SetUserMethod {wm deiconify .vtkInteract}
[ren1 GetActiveCamera] Zoom 1.5
renWin Render
#renWin SetFileName "complexV.tcl.ppm"
#renWin SaveImageAsPPM

# prevent the tk window from showing up then start the event loop
wm withdraw .


