/*=========================================================================

Program:   Visualization Toolkit
Module:    vtkWin32OpenGL2RenderWindow.h

Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
All rights reserved.
See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

This software is distributed WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkWin32OpenGLD3D11RenderWindow
 * @brief   OpenGL - DirectX rendering window
 */

#ifndef vtkWin32OpenGLD3D11RenderWindow_h
#define vtkWin32OpenGLD3D11RenderWindow_h

#include "vtkWin32OpenGLRenderWindow.h"
#include "vtkRenderingOpenGL2Module.h" // For export macro

#include "d3d11.h"
#include <wrl/client.h>

using Microsoft::WRL::ComPtr;

class VTKRENDERINGOPENGL2_EXPORT vtkWin32OpenGLD3D11RenderWindow : public vtkWin32OpenGLRenderWindow
{
public:
  static vtkWin32OpenGLD3D11RenderWindow* New();
  vtkTypeMacro(vtkWin32OpenGLD3D11RenderWindow, vtkWin32OpenGLRenderWindow);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  void Initialize(void) override;

  void Lock();
  void Unlock();
  void RegisterSharedTexture(unsigned int textureHandle);
  void UnregisterSharedTexture();
  void ResizeTexture();
  void CopyToTexture(ID3D11Texture2D*);

  vtkGetMacro(Device, ComPtr<ID3D11Device>);

  // Specify the DGXI adapter to be used for initialization.
  // If left unspecified, the first available adapter is used.
  void SetAdapterId(LUID uid) { this->AdapterId = uid; }

protected:
  vtkWin32OpenGLD3D11RenderWindow() = default;
  ~vtkWin32OpenGLD3D11RenderWindow() = default;

private:
  vtkWin32OpenGLD3D11RenderWindow(const vtkWin32OpenGLD3D11RenderWindow&) = delete;
  void operator=(const vtkWin32OpenGLD3D11RenderWindow&) = delete;

  D3D_FEATURE_LEVEL MinFeatureLevel = D3D_FEATURE_LEVEL_11_1;

  ComPtr<ID3D11Device> Device = nullptr;
  ComPtr<ID3D11DeviceContext> D3DDeviceContext = nullptr;

  ComPtr<ID3D11Texture2D> D3DSharedTexture = nullptr;
  HANDLE DeviceHandle = 0;

  int TextureId = 0;
  HANDLE GLSharedTextureHandle = 0;

  LUID AdapterId = { 0, 0 };
};

#endif
