﻿using UnityEngine;

namespace ImstkUnity
{
    [AddComponentMenu("Imstk/StaticModel")]
    public class StaticModel : DynamicalModel
    {
        protected override void OnImstkInit()
        {
            // Get dependencies
            meshFilter = gameObject.GetComponentFatal<MeshFilter>();
            transformComp = gameObject.GetComponentFatal<Transform>();

            // Make sure mesh filter is read/writable
            if (!meshFilter.mesh.isReadable)
            {
                Debug.LogWarning(gameObject.name + "'s MeshFilter Mesh must be readable (check the meshes import settings)");
                return;
            }

            imstkObject = InitObject();
            SimulationManager.sceneManager.getActiveScene().addSceneObject(imstkObject);
            InitGeometry();
            Configure();
        }

        protected override void Configure()
        {
            //throw new NotImplementedException();
        }

        protected override void InitGeometry()
        {
            // Setup the collision geometry in its already post transform configuration
            // as it is a static geometry and will not be transformed
            if (collisionGeomFilter != null)
            {
                Imstk.Geometry colGeom = GetCollidingGeometry();
                Imstk.Mat4d m = transformComp.localToWorldMatrix.ToMat4d();
                colGeom.transform(m, Imstk.Geometry.TransformType.ApplyToData);
                imstkObject.setCollidingGeometry(colGeom);
            }
            else
            {
                Debug.LogError("No collision geometry provided to DynamicalModel on object " + gameObject.name);
            }
        }

        protected override Imstk.CollidingObject InitObject()
        {
            return new Imstk.CollidingObject(GetFullName());
        }
    }
}
