﻿using UnityEngine;

namespace ImstkUnity
{
    /// <summary>
    /// This is the base class of Imstk scripts. It exists to provide
    /// different init functions for Imstk classes. This is so that we
    /// can control initialization order in the SimulationManager
    /// </summary>
    public abstract class ImstkBehaviour : MonoBehaviour
    {
        public string GetFullName()
        {
            string name = gameObject.name;
            Transform parent = gameObject.transform.parent;
            while (parent != null)
            {
                name = parent.gameObject.name + "/" + name;
                parent = parent.transform.parent;
            }
            return name;
        }
        public void ImstkDestroy()
        {
            OnImstkDestroy();
        }

        public void ImstkInit() { OnImstkInit(); }

        public void ImstkStart() { OnImstkStart(); }


        /// <summary>
        /// Called before initializing the scene
        /// </summary>
        protected virtual void OnImstkInit() { }

        /// <summary>
        /// Called after scene has been initialized
        /// </summary>
        protected virtual void OnImstkStart() { }


        /// <summary>
        /// Called when done
        /// </summary>
        protected virtual void OnImstkDestroy() { }
    }
}
