﻿using UnityEngine;

namespace ImstkUnity
{
    public class OrientedBox : Geometry
    {
        public Vector3 center = Vector3.zero;
        public Vector3 extents = new Vector3(0.5f, 0.5f, 0.5f);
        public Quaternion orientation = Quaternion.identity;

        public OrientedBox()
        {
            geomType = GeometryType.OrientedBox;
        }

        public Vector3 GetTransformedCenter(Transform transform)
        {
            return transform.TransformPoint(center);
        }

        public Vector3 GetTransformedExtent(Transform transform)
        {
            return Vector3.Scale(extents, transform.localScale);
        }

        public Quaternion GetTransformedOrientation(Transform transform)
        {
            return orientation * transform.rotation;
        }

        public Mesh GetMesh()
        {
            Imstk.OrientedBox geom = this.ToImstkGeometry() as Imstk.OrientedBox;
            Imstk.SurfaceMesh surfMesh = Imstk.Utils.toSurfaceMesh(geom);
            return surfMesh.ToMesh();
        }
    }
}