﻿using ImstkUnity;
using UnityEditor;

namespace ImstkEditor
{
    [CustomEditor(typeof(StaticModel))]
    class StaticModelEditor : Editor
    {
        public override void OnInspectorGUI()
        {
            StaticModel script = target as StaticModel;
            EditorGUI.BeginChangeCheck();

            GeometryFilter collisionGeomFilter = EditorUtils.GeomFilterField("Collision Geometry", script.collisionGeomFilter);
            
            if (EditorGUI.EndChangeCheck())
            {
                Undo.RegisterCompleteObjectUndo(script, "Change of Parameters");
                script.collisionGeomFilter = collisionGeomFilter;
            }
        }
    }
}