﻿using ImstkUnity;
using UnityEditor;

namespace ImstkEditor
{
    /// <summary>
    /// This class observes the play mode state to properly pause and step
    /// Imstk in the Unity editor
    /// </summary>
    [InitializeOnLoad]
    class PlayModeStateObserver
    {
        static PlayModeStateObserver()
        {
#if UNITY_EDITOR
            // Perform imstk install if developer mode is on
            ImstkSettings settings = ImstkSettings.Instance();
            if (settings.useDeveloperMode &&
                EditorUtility.DisplayDialog("Do you want to install imstk",
                "To install imstk select yes and provide your imstk build/install directory. If you would not " +
                "like to be prompted again, please turn off developer mode in imstk settings. Note: " +
                "This prompt will be displayed upon installation again, select no second time.", "Yes", "No"))
            {
                settings.installSourcePath =
                    EditorUtility.OpenFolderPanel("Imstk Install Directory (Development Use)", settings.installSourcePath, "");
                EditorUtils.installImstk(settings.installSourcePath);
                EditorUtility.SetDirty(settings);
                AssetDatabase.SaveAssets();
            }
#endif

            //EditorApplication.playModeStateChanged += playModeStateChanged;
            EditorApplication.pauseStateChanged += pauseStateChanged;
        }

        private static void pauseStateChanged(PauseState state)
        {
            if (SimulationManager.sceneManager != null)
            {
                bool paused = SimulationManager.sceneManager.getPaused();
                if (paused)
                {
                    SimulationManager.sceneManager.setPaused(true);
                }
                else
                {
                    SimulationManager.sceneManager.setPaused(false);
                }
            }
        }

        //private static void playModeStateChanged(PlayModeStateChange state) { }
    }
}
