﻿using ImstkUnity;
using UnityEngine;
using UnityEditor;

namespace ImstkEditor
{
    /// <summary>
    /// For menu'd geometry operations. Could spin off into own GUI as it gets larger.
    /// GUI for parameters needs to be done up as well for some
    /// </summary>
    class GeometryMenuItems
    {
        /// <summary>
        /// Creates UVs per vertex on plane for GameObjects MeshFilter mesh
        /// </summary>
        [MenuItem("Imstk/Geometry/ProjectUVPlane")]
        private static void ProjectUVPlane()
        {
            Vector2 scale = new Vector2(1.0f, 1.0f);

            // \todo: Plane option
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("ProjectUVPlane failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            Mesh inputMesh = meshFilter.sharedMesh;
            meshFilter.sharedMesh = new Mesh();
            meshFilter.sharedMesh.name = inputMesh.name;

            UVPlaneProjectEditor.Init(inputMesh, meshFilter.sharedMesh);
        }

        /// <summary>
        /// Creates UVs per vertex on sphere for GameObjects MeshFilter mesh
        /// </summary>
        [MenuItem("Imstk/Geometry/ProjectUVSphere")]
        private static void ProjectUVSphere()
        {
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("ProjectUVSphere failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            Mesh inputMesh = meshFilter.sharedMesh;
            meshFilter.sharedMesh = new Mesh();
            meshFilter.sharedMesh.name = inputMesh.name;

            UVSphereProjectEditor.Init(inputMesh, meshFilter.sharedMesh);
        }

        /// <summary>
        /// Laplacian smoothens a mesh
        /// </summary>
        [MenuItem("Imstk/Geometry/LaplaceSmoothMesh")]
        private static void LaplaceSmoothMesh()
        {
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("LaplaceSmoothMesh failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            Mesh inputMesh = meshFilter.sharedMesh;
            meshFilter.sharedMesh = new Mesh();
            meshFilter.sharedMesh.name = inputMesh.name;

            LaplaceSmoothEditor.Init(inputMesh, meshFilter.sharedMesh);
        }

        /// <summary>
        /// Subdivides a triangle mesh
        /// </summary>
        [MenuItem("Imstk/Geometry/SubdivideMesh")]
        private static void SubdivideMesh()
        {
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("LaplaceSmoothMesh failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            Mesh inputMesh = meshFilter.sharedMesh;
            meshFilter.sharedMesh = new Mesh();
            meshFilter.sharedMesh.name = inputMesh.name;

            SubdivideMeshEditor.Init(inputMesh, meshFilter.sharedMesh);
        }

        /// <summary>
        /// Generates a tet grid on the currently selected object
        /// </summary>
        [MenuItem("Imstk/Geometry/Generate TetGrid")]
        private static void GenerateTetGrid()
        {
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("TetGrid generation failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            Mesh inputMesh = meshFilter.sharedMesh;
            meshFilter.sharedMesh = new Mesh();
            meshFilter.sharedMesh.name = inputMesh.name;

            GeometryFilter tetGridFilter = inputObj.AddComponent<GeometryFilter>();
            ImstkMesh tetMesh = ScriptableObject.CreateInstance<ImstkMesh>();
            tetMesh.geomType = GeometryType.TetrahedralMesh;
            tetGridFilter.SetGeometry(tetMesh);

            // Operates on the whole object as it provides the tetrahedral mesh on a separate geometry
            TetrahedralGridEditor.Init(meshFilter.sharedMesh, tetGridFilter.inputImstkGeom as ImstkMesh);
        }

        /// <summary>
        /// Generates a plane mesh on the currently selected object
        /// </summary>
        [MenuItem("Imstk/Geometry/Generate Plane")]
        private static void GeneratePlane()
        {
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("Plane generation failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            PlaneMeshEditor.Init(meshFilter.sharedMesh);
        }

        /// <summary>
        /// Generates a line mesh on the currently selected object
        /// </summary>
        [MenuItem("Imstk/Geometry/Generate LineMesh")]
        private static void GenerateLineMesh()
        {
            GameObject inputObj = Selection.activeObject as GameObject;
            if (inputObj == null)
            {
                Debug.LogWarning("Plane generation failed, no object selected.");
                return;
            }
            MeshFilter meshFilter = inputObj.GetComponentOrCreate<MeshFilter>();
            LineMeshEditor.Init(meshFilter.sharedMesh);
        }
    }
}