﻿using ImstkUnity;
using UnityEngine;
using UnityEditor;

namespace ImstkEditor
{
    /// <summary>
    /// Generates a plane mesh for MeshFilter
    /// </summary>
    public class PlaneMeshEditor : EditorWindow
    {
        //public Vector3 size = new Vector3(1.0f, 0.25f, 1.0f);
        public Vector2Int dim = new Vector2Int(8, 8);
        //public Vector3 center = new Vector3(0.0f, 0.0f, 0.0f);
        public Mesh outputMesh = null;

        public static void Init(Mesh outputMesh)
        {
            PlaneMeshEditor window = GetWindow(typeof(PlaneMeshEditor)) as PlaneMeshEditor;
            window.outputMesh = outputMesh;
            window.UpdateEditorResults();
            window.Show();
        }

        void OnGUI()
        {
            EditorGUI.BeginChangeCheck();
            outputMesh = EditorGUILayout.ObjectField("Input Mesh: ", outputMesh, typeof(Mesh), true) as Mesh;
            //Vector3 tSize = EditorGUILayout.Vector3Field("Size: ", size);
            Vector2Int tDim = EditorGUILayout.Vector2IntField("Grid Dimensions: ", dim);
            //Vector3 tCenter = EditorGUILayout.Vector3Field("Center: ", center);

            // \todo: How to get undo to also call UpdateInputObj?
            if (EditorGUI.EndChangeCheck())
            {
                Undo.RegisterCompleteObjectUndo(this, "Change of Parameters");
                //size = tSize.cwiseMax(new Vector3(0.0f, 0.0f, 0.0f));
                dim = tDim.cwiseMax(new Vector2Int(2, 2));
                //center = tCenter;

                UpdateEditorResults();
            }
        }

        private void UpdateEditorResults()
        {
            ImstkMesh planeMesh = Utility.GetXYPlane(dim.x, dim.y);
            GeomUtil.CopyMesh(planeMesh.ToMesh(), outputMesh);
        }
    }
}