﻿using System;
using System.Threading;
using UnityEngine;

namespace ImstkUnity
{
    [AddComponentMenu("Imstk/VrpnDeviceManager")]
    public class VrpnDeviceManager : MonoBehaviour
    {
        private static VrpnDeviceManager _instance;
        
        // Probably Refactor to Singleton base class
        public static VrpnDeviceManager Instance
        {
            get { return _instance; }
        }

        public string host = "localhost";
        public int port = 3883;

        private Imstk.VRPNDeviceManager manager;
        private Thread thread;
        private bool running = false;

        public void Awake()
        {
            // Primitive singleton 
            if (_instance != null && _instance != this)
            {
                Destroy(this.gameObject);
            }
            else
            {
                _instance = this;
            }
            InitManager();
        }

        public void InitManager()
        {
            if (manager == null)
            {
                manager = new Imstk.VRPNDeviceManager(host, port);
                if (manager == null) Debug.LogError("Could not create VRPNDevice Manager");
                manager.setSleepDelay(20);
                manager.init();
            }
        }

        public Imstk.DeviceClient MakeDeviceClient(ImstkUnity.VrpnDevice device)
        {
            return manager.makeDeviceClient(device.Name, device.Type);
        }    

        public void StartManager()
        {
            if (running) return;

            InitManager();
            running = true;
            Debug.Log("VRPN Thread Starting");
            thread = new Thread(() =>
            {
                while (running)
                {
                    manager.update();
                }
            });
            thread.Start();
        }
        public void StopManager()
        {
            if (manager == null) return;
            if (!running) return; 
            running = false;
            thread.Join();

            Debug.Log("VRPN Thread Stopping");
            manager.uninit();
            thread = null;
        }
    }
}
