﻿using UnityEngine;
using System.Threading;

namespace ImstkUnity
{
    // HS-2022-feb-02 Should be refactored to remove the "manager" functionality from the
    // Device, see the VRPNDevice for the pattern. Remove `static` components
    // from here
    [AddComponentMenu("Imstk/OpenHapticsDevice")]
    public class OpenHapticsDevice : TrackingDevice
    {
        public string deviceName = "default";

        public static Imstk.HapticDeviceManager openHapticDeviceManager = null;
        public static bool hapticsRunning = false;
        public static Thread hapticThread = null;

        public static void InitManager()
        {
            if (openHapticDeviceManager != null)
            {
                openHapticDeviceManager.init();
            }
        }

        public void Start()
        {
            GetDevice();
        }

        public static void StartManager()
        {
            // Launch haptics on a separate thread if using
            if (openHapticDeviceManager != null)
            {
                hapticsRunning = true;
                Debug.Log("Haptic Thread Starting");
                hapticThread = new Thread(() =>
                {
                    while (hapticsRunning)
                    {
                        if (openHapticDeviceManager != null)
                        {
                            openHapticDeviceManager.update();
                        }
                    }
                });
                hapticThread.Start();
            }
        }
        public static void StopManager()
        {
            if (openHapticDeviceManager != null)
            {
                hapticsRunning = false;
                hapticThread.Join();

                Debug.Log("Haptic Thread Stopping");
                openHapticDeviceManager.uninit();
                openHapticDeviceManager = null;
                hapticThread = null;
            }
        }

        protected override Imstk.DeviceClient MakeDevice()
        {
            if (openHapticDeviceManager == null)
            {
                openHapticDeviceManager = new Imstk.HapticDeviceManager();
            }

            // Creates the default device (specify name for specific one)
            if (deviceName == "default")
            {
                return openHapticDeviceManager.makeDeviceClient();
            }
            else
            {
                return openHapticDeviceManager.makeDeviceClient(deviceName);
            }
        }
    }
}