#pragma once

#include <memory>

#include "CommonStructs.h"
#include "PInvoke.h"
#include "glm/glm.hpp"


namespace imstk
{
class DeviceTracker;
} // namespace imstk


extern std::shared_ptr<imstk::DeviceTracker> hapticDeviceController;

extern "C"
{
    ///
    /// \brief Setups the Haptic Device
    ///
    IMSTK_EXPORT void setupHapticDevice(const int objectHandle, const char* phantomOmni1Name);

    ///
    /// \brief Gets the device's current rotation
    ///
    IMSTK_EXPORT Vec3f getHapticDevicePosition();

    ///
    /// \brief Gets the device's current rotation
    ///
    IMSTK_EXPORT Vec4f getHapticDeviceRotation();

    ///
    /// \brief Gets the device's current position offset
    ///
    IMSTK_EXPORT Vec3f getHapticDevicePositionOffset();

    ///
    /// \brief Gets the device's current rotation offset
    ///
    IMSTK_EXPORT Vec4f getHapticDeviceRotationOffset();

    ///
    /// \brief Deletes the Device Controller
    ///
    IMSTK_EXPORT void deleteHapticDeviceController();
}
