#include "HapticDevice.h"

#include <imstkCamera.h>
#include <imstkCollisionGraph.h>
#include <imstkDeviceTracker.h>
#include <imstkHDAPIDeviceClient.h>
#include <imstkHDAPIDeviceServer.h>
#include <imstkPbdModel.h>
#include <imstkPbdObject.h>
#include <imstkScene.h>
#include <imstkSceneObject.h>
#include <imstkSceneObjectController.h>
#include <imstkSimulationManager.h>

#include <string>

#include "DynamicObject.h"
#include "SimManager.h"

#ifdef iMSTK_USE_OPENHAPTICS

std::shared_ptr<imstk::DeviceTracker> hapticDeviceController = nullptr;

void setupHapticDevice(const int objectHandle, const char* phantomOmni1Name)
{
    // Device Client
    auto client = std::make_shared<imstk::HDAPIDeviceClient>(std::string(phantomOmni1Name));

    // Device Server
    auto server = std::make_shared<imstk::HDAPIDeviceServer>();
    server->addDeviceClient(client);

    // Add Module to Simulation
    simManager::sdk->addModule(server);

    // Create Object
    std::shared_ptr<imstk::DynamicObject> dynamicObject = dynamicObjects[objectHandle];
    std::shared_ptr<imstk::SceneObject> sceneObject = dynamicObject;

    // Device Tracker
    hapticDeviceController = std::make_shared<imstk::DeviceTracker>(client);
    hapticDeviceController->setTranslationScaling(0.1);
    auto controller =
        std::make_shared<imstk::SceneObjectController>(sceneObject, hapticDeviceController);

    // Add to scene
    auto scene = simManager::sdk->getActiveScene();
    scene->addObjectController(controller);
}


Vec3f getHapticDevicePosition()
{
    const imstk::Vec3d& deviceCurrentPosition = hapticDeviceController->getPosition();

    return Vec3f{ static_cast<float>(deviceCurrentPosition.x()),
                  static_cast<float>(deviceCurrentPosition.y()),
                  static_cast<float>(deviceCurrentPosition.z()) };
}


Vec4f getHapticDeviceRotation()
{
    const imstk::Quatd& deviceCurrentRotation = hapticDeviceController->getRotation();

    return Vec4f{ static_cast<float>(deviceCurrentRotation.x()),
                  static_cast<float>(deviceCurrentRotation.y()),
                  static_cast<float>(deviceCurrentRotation.z()),
                  static_cast<float>(deviceCurrentRotation.w()) };
}

Vec3f getHapticDevicePositionOffset()
{
    const imstk::Vec3d& deviceCurrentPositionOffset =
        hapticDeviceController->getTranslationOffset();

    return Vec3f{ static_cast<float>(deviceCurrentPositionOffset.x()),
                  static_cast<float>(deviceCurrentPositionOffset.y()),
                  static_cast<float>(deviceCurrentPositionOffset.z()) };
}

Vec4f getHapticDeviceRotationOffset()
{
    const imstk::Quatd& deviceCurrentRotationOffset = hapticDeviceController->getRotationOffset();

    return Vec4f{ static_cast<float>(deviceCurrentRotationOffset.x()),
                  static_cast<float>(deviceCurrentRotationOffset.y()),
                  static_cast<float>(deviceCurrentRotationOffset.z()),
                  static_cast<float>(deviceCurrentRotationOffset.w()) };
}

void deleteHapticDeviceController()
{
    hapticDeviceController = nullptr;
}

#endif