﻿using System.Dynamic;
using System.Runtime.InteropServices;
using UnityEngine;


namespace Imstk
{

    [AddComponentMenu("Imstk/HapticDeviceController")]
    public class HapticDeviceController : ImstkBehaviour
    {
        public string hapticDeviceName;
        public float setForce;
        protected int objHandle = -1;


        public override void ImstkAwake()
        {
            objHandle = gameObject.GetComponent<DynamicalModel>().GetHandle();

            setupHapticDevice(objHandle, hapticDeviceName);
        }

        public override void ImstkStart() { }

        public void Update()
        {
            float horizontalMovement = Input.GetAxis("Mouse X");
            float verticalMovement = Input.GetAxis("Mouse Y");

            // Vector3 hapticPosition = getHapticDevicePosition();

            // print(hapticPosition);

            //transform.Translate(hapticPosition.x * Time.deltaTime, 0f, hapticPosition.z * Time.deltaTime);

        }

        public override void ImstkDestroy()
        {
            // Deletes Haptic Device Controller

            deleteHapticDeviceController();
        }


        [DllImport(PInvoke.ImstkUnityLibName)]
        public static extern void setupHapticDevice(int objectHandle, string phantomOmni1Name);

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector3 getHapticDevicePosition();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern void printHapticDevicePosition();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector4 getHapticDeviceRotation();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector3 getHapticDevicePositionOffset();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern Vector4 getHapticDeviceRotationOffset();

        [DllImport(PInvoke.ImstkUnityLibName)]
        protected static extern void deleteHapticDeviceController();





    }
}