// Upgrade NOTE: replaced 'mul(UNITY_MATRIX_MVP,*)' with 'UnityObjectToClipPos(*)'
// https://forum.unity.com/threads/issues-creating-fixed-width-lines-using-geometry-shader-in-view-space.442178/
// https://gist.github.com/phi-lira/225cd7c5e8545be602dca4eb5ed111ba
Shader "Imstk/ConnectiveTissue-1"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}
        _Thickness("Line Width", Range(0,100)) = 1
        _UVThickness("UV Width", Range(0,1)) = 0.1
    }
    SubShader
    {
        Tags{"RenderType" = "Opaque" 
            "RenderPipeline" = "UniversalRenderPipeline" 
            "IgnoreProjector" = "True"
        }
        LOD 100

        Pass
        {
            // "Lightmode" tag must be "UniversalForward" or not be defined in order for
            // to render objects.
            Name "StandardLit"
            Tags{"LightMode" = "UniversalForward"}

            Blend[_SrcBlend][_DstBlend]
            ZWrite[_ZWrite]
            Cull[_Cull]

            HLSLPROGRAM
            #pragma vertex vert
            #pragma geometry geom
            #pragma fragment frag
            // make fog work
            #pragma multi_compile_fog

            // The Core.hlsl file contains definitions of frequently used HLSL
            // macros and functions, and also contains #include references to other
            // HLSL files (for example, Common.hlsl, SpaceTransforms.hlsl, etc.).
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"

//            #pragma multi_compile _ _MAIN_LIGHT_SHADOWS
//            #pragma multi_compile _ _MAIN_LIGHT_SHADOWS_CASCADE
// Note, v11 changes this to :
#pragma multi_compile _ _MAIN_LIGHT_SHADOWS _MAIN_LIGHT_SHADOWS_CASCADE _MAIN_LIGHT_SHADOWS_SCREEN


            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"

            CBUFFER_START(UnityPerMaterial)
            float _Thickness;
            float _UVThickness;
            CBUFFER_END

            struct appdata
            {
                float4 positionOS : POSITION;
                float4 normalOS : NORMAL;
                float2 uv : TEXCOORD0;
            };

            struct v2g
            {
                float4 positionCS : POSITION;
                float3 positionWS : TEXCOORD2;
                float3 normalWS : NORMAL;
                float2 uv : TEXCOORD0;
            };

            struct g2f
            {
                float4 positionCS : SV_POSITION;
                float3 positionWS : TEXCOORD2;
                float3 normalWS : NORMAL;
                float2 uv : TEXCOORD0;
            };

            sampler2D _MainTex;
            float4 _MainTex_ST;

            v2g vert (appdata IN)
            {
                v2g OUT;
                VertexPositionInputs positionInputs = GetVertexPositionInputs(IN.positionOS.xyz);
                OUT.positionCS = positionInputs.positionCS;
                OUT.positionWS = positionInputs.positionWS;

                VertexNormalInputs normalInputs = GetVertexNormalInputs(IN.normalOS.xyz);
                OUT.normalWS = normalInputs.normalWS;

                OUT.uv = TRANSFORM_TEX(IN.uv, _MainTex);
                return OUT;
            }

            [maxvertexcount(4)]
            void geom(line v2g v[2], inout TriangleStream<g2f> ts)
            {
                g2f g[4];

                //float4 p1 = UnityObjectToClipPos(v[0].vertex);
                //float4 p2 = UnityObjectToClipPos(v[1].vertex);

                float4 p1 = v[0].positionCS;
                float4 p2 = v[1].positionCS;

                float2 dir = normalize(p2.xy - p1.xy);
                float2 normal = float2(-dir.y, dir.x);

                //float4 offset1 = float4(normal * p1.w * _Thickness / 2.0f, 0, 0);
                //float4 offset2 = float4(normal * p2.w * _Thickness / 2.0f, 0, 0);
                float4 offset1 = float4(normal * _Thickness / 2.0f, 0, 0);
                float4 offset2 = float4(normal * _Thickness / 2.0f, 0, 0);
                offset1.x *= _ScreenParams.y / _ScreenParams.x;
                offset2.x *= _ScreenParams.y / _ScreenParams.x;

                float4 o1 = p1 + offset1;
                float4 o2 = p1 - offset1;
                float4 o3 = p2 + offset2;
                float4 o4 = p2 - offset2;

                g[0].positionCS = o1;
                g[1].positionCS = o2;
                g[2].positionCS = o3;
                g[3].positionCS = o4;

                // TEMP forward world space position from incoming points
                // => will make wonky lighting
                g[0].positionWS = v[0].positionWS;
                g[1].positionWS = v[0].positionWS;
                g[2].positionWS = v[1].positionWS;
                g[3].positionWS = v[1].positionWS;

                // Forward normals from incoming points
                g[0].normalWS = v[0].normalWS;
                g[1].normalWS = v[0].normalWS;
                g[2].normalWS = v[1].normalWS;
                g[3].normalWS = v[1].normalWS;

                float2 uv1 = v[0].uv;
                float2 uv2 = v[1].uv;

                float2 uvDir = normalize(uv2 - uv1);
                float2 uvOffset = float2(-uvDir.y, uvDir.x) * _UVThickness;
                

                g[0].uv = uv1 + uvOffset;
                g[1].uv = uv1 - uvOffset;
                g[2].uv = uv2 + uvOffset;
                g[3].uv = uv2 - uvOffset;


                ts.Append(g[0]);
                ts.Append(g[1]);
                ts.Append(g[2]);
                ts.Append(g[3]);
            }

            half4 frag(g2f IN) : SV_Target
            {
                // sample the texture
                half4 color = tex2D(_MainTex, IN.uv);
                //half4 col = half4(1.0, 0, 0, 1.0);

                //float4 shadowCoord = TransformWorldToShadowCoord(IN.positionWS.xyz);
                //Light light = GetMainLight();
                //Light light = GetMainLight(shadowCoord);
                //Light light;
                //light.direction = half3(1, 0, 0);
                //light.color = half3(.5, .5, .5);
                

                //half3 diffuse = LightingLambert(light.color, light.direction, IN.normalWS);

                return half4(1.0,0.0,0.0,1.0);
                //return half4(color.rgb * diffuse, color.a);
                //return half4(color.rgb * diffuse * light.shadowAttenuation, color.a);
                //return half4(light.direction, 1.0);
                //return half4(IN.normalWS.xyz, 1.0);
            }
            ENDHLSL
        }
        // Used for rendering shadowmaps
        UsePass "Universal Render Pipeline/Lit/ShadowCaster"

        // Used for depth prepass
        // If shadows cascade are enabled we need to perform a depth prepass. 
        // We also need to use a depth prepass in some cases camera require depth texture
        // (e.g, MSAA is enabled and we can't resolve with Texture2DMS
        UsePass "Universal Render Pipeline/Lit/DepthOnly"

        // Used for Baking GI. This pass is stripped from build.
        UsePass "Universal Render Pipeline/Lit/Meta"
    }
}
