#include "TaskGraph.h"
#include "imstkTaskGraph.h"
#include "imstkSequentialTaskGraphController.h"
#include "imstkTbbTaskGraphController.h"
#include "imstkTaskGraphVizWriter.h"

std::unordered_map<void*, std::shared_ptr<imstk::TaskGraph>> taskGraphs;

void* genTaskGraph()
{
    std::shared_ptr<imstk::TaskGraph> taskGraph = std::make_shared<imstk::TaskGraph>();
    taskGraphs[taskGraph.get()] = taskGraph;
    return taskGraph.get();
}

void* genTaskGraphCopy(void* objectHandle)
{
    std::shared_ptr<imstk::TaskGraph> taskGraph = std::make_shared<imstk::TaskGraph>();
    *taskGraph = *static_cast<imstk::TaskGraph*>(objectHandle);
    taskGraphs[taskGraph.get()] = taskGraph;
    return taskGraph.get();
}

void executeTaskGraph(void* objectHandle, const bool sequential)
{
    std::shared_ptr<imstk::TaskGraph> taskGraph = taskGraphs[objectHandle];
    if (sequential)
    {
        std::shared_ptr<imstk::SequentialTaskGraphController> controller =
            std::make_shared<imstk::SequentialTaskGraphController>();
        controller->setTaskGraph(taskGraph);
        controller->initialize();
        controller->execute();
    }
    else
    {
        std::shared_ptr<imstk::TbbTaskGraphController> controller =
            std::make_shared<imstk::TbbTaskGraphController>();
        controller->setTaskGraph(taskGraph);
        controller->initialize();
        controller->execute();
    }
}

void writeTaskGraph(void* objectHandle, const char* filePathName)
{
    std::shared_ptr<imstk::TaskGraph> taskGraph = taskGraphs[objectHandle];
    std::string filePathNameStr = std::string(filePathName);
    std::shared_ptr<imstk::TaskGraphVizWriter> writer =
        std::make_shared<imstk::TaskGraphVizWriter>();
    writer->setInput(taskGraph);
    writer->setFileName(filePathNameStr);
    writer->write();
}

void deleteTaskGraph(void* objectHandle)
{
    if (taskGraphs.count(objectHandle))
    {
        taskGraphs[objectHandle] = nullptr;
        taskGraphs.erase(objectHandle);
    }
}
