#pragma once
#include "Geometry.h"
#include "PInvoke.h"

struct RigidParams
{
    double test;
};

extern "C"
{
    ///
    /// \brief Generate an empty PbdObject, return pointer to it
    ///
    IMSTK_EXPORT void* genRigidObject(const char* objName);

    ///
    /// \brief Sets the parameters of the specified RigidObject's model
    ///
    IMSTK_EXPORT void configureRigidObject(const void* objectHandle, const RigidParams params);

    ///
    /// \brief Initializes a RigidObject with a FemModel.
    ///
    IMSTK_EXPORT void initRigidObject(const void* objectHandle);
}