#include "RigidObject.h"

#include <imstkCamera.h>
#include <imstkCollisionGraph.h>
#include <imstkLogger.h>
#include <imstkRigidBodyModel.h>
#include <imstkRigidObject.h>
#include <imstkScene.h>

#include "DynamicObject.h"
#include "SimManager.h"

void* genRigidObject(const char* objName)
{
    std::shared_ptr<imstk::RigidObject> rbdObject = std::make_shared<imstk::RigidObject>(std::string(objName));
    dynamicObjects[rbdObject.get()] = rbdObject;
    return rbdObject.get();
}

void configureRigidObject(void* objectHandle, RigidParams params)
{
    std::shared_ptr<imstk::DynamicObject> dynamicObject = dynamicObjects[objectHandle];
    auto rigidModel =
        std::static_pointer_cast<imstk::RigidBodyModel>(dynamicObject->getDynamicalModel());

    auto rigidConfig = std::make_shared<imstk::RigidBodyConfig>();
    rigidConfig->m_rigidBodyType = imstk::RigidBodyType::Kinematic;
    rigidModel->configure(rigidConfig);
}

void initRigidObject(void* objectHandle)
{
    // Get the object
    if (dynamicObjects.count(objectHandle) == 0)
    {
        LOG(WARNING) << "Cannot initialize rigid object, handle doesn't exist";
        return;
    }
    std::shared_ptr<imstk::RigidObject> rigidObject =
        std::dynamic_pointer_cast<imstk::RigidObject>(dynamicObjects.at(objectHandle));
    if (rigidObject == nullptr)
    {
        LOG(WARNING) << "Cannot initialize rigid object, object at handle refers to different type";
        return;
    }

    // Create Model
    auto rigidModel = std::make_shared<imstk::RigidBodyModel>();
    rigidObject->setDynamicalModel(rigidModel);

    // Add to scene
    auto scene = simManager::sdk->getActiveScene();
    scene->addSceneObject(rigidObject);
}