#pragma once
#include <string>

#include "PInvoke.h"
#include "g3log/g3log.hpp"

extern void (*Log)(const char* str);
extern void (*LogWarning)(const char* str);
extern void (*LogError)(const char* str);

class ForwardingG3Sink
{
public:
    void ReceiveLogMessage(g3::LogMessageMover logEntry)
    {
        const LEVELS level = logEntry.get()._level;
        if (level.value == WARNING.value)
        {
            if (LogWarning != nullptr)
                LogWarning(logEntry.get().toString().c_str());
        }
        else if (level.value == DEBUG.value)
        {
            if (Log != nullptr)
                Log(logEntry.get().toString().c_str());
        }
        else if (g3::internal::wasFatal(level))
        {
            if (LogError != nullptr)
                LogError(logEntry.get().toString().c_str());
        }
        else
        {
            if (Log != nullptr)
                Log(logEntry.get().toString().c_str());
        }
    }
};

extern "C"
{
    ///
    /// \brief Creates the logger
    ///
    IMSTK_EXPORT void genLogger();

    ///
    /// \brief Cleans up the logger
    ///
    IMSTK_EXPORT void deleteLogger();


    ///
    /// \brief Register function to log
    ///
    IMSTK_EXPORT void setLogFunc(void (*func)(const char* str));

    ///
    /// \brief Register function to log a warning
    /// 
    IMSTK_EXPORT void setLogWarningFunc(void (*func)(const char* str));

    ///
    /// \brief Register function to log an error
    /// 
    IMSTK_EXPORT void setLogErrorFunc(void (*func)(const char* str));
}