﻿using System;
using System.Runtime.InteropServices;
using UnityEngine;

namespace Imstk.Movement
{
    // Moves the set distance
    [AddComponentMenu("Imstk/PbdForwardMove")]
    public class PbdForwardMove : ImstkBehaviour
    {
        public double distanceToMove = 1.0;
        public double timeStep = 0.01;
        public bool useTransformDirection = false;
        public Vector3 direction = new Vector3(0.0f, 0.0f, 0.0f);

        private double t = 0.0;
        private IntPtr pbdObjectHandle = IntPtr.Zero;

        protected override void OnImstkStart()
        {
            // Have OnImstkPostUpdate called
            RegisterPostUpdate();

            PbdModel model = gameObject.GetComponentFatal<PbdModel>();
            pbdObjectHandle = model.GetHandle();

            // Get the direction to move
            if (useTransformDirection)
            {
                if (model != null)
                    direction = (model.initTransform * new Vector3(0.0f, 0.0f, 1.0f)).normalized;
            }
        }

        protected override void OnImstkPostUpdate()
        {
            Vector3 dx = (float)(Math.Sin(t) * 0.5 * distanceToMove * timeStep) * direction;
            translateVertices(pbdObjectHandle, dx);
            t += timeStep;
        }

        [DllImport(PInvoke.ImstkUnityLibName)]
        private static extern void translateVertices(IntPtr objectHandle, Vector3 dx);
    }
}